/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_6880;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class FakePlayerScreenHandler
extends ServerOnlyScreenHandler<Claim> {
    private final Claim claim;
    private boolean removeMode;

    private FakePlayerScreenHandler(int syncId, class_1661 playerInventory, Claim claim) {
        super(syncId, playerInventory, 6, claim);
        this.claim = claim;
    }

    public static void open(class_1657 player, final Claim claim) {
        class_3908 fac = new class_3908(){

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new FakePlayerScreenHandler(syncId, inv, claim);
            }

            public class_2561 method_5476() {
                return ClaimUtils.translatedText("flan.screenMenuFakePlayers", new Object[0]);
            }
        };
        player.method_17355(fac);
    }

    @Override
    protected void fillInventoryWith(class_1657 player, SeparateInv inv, Claim claim) {
        List<String> players = claim.getAllowedFakePlayerUUID();
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                class_1799 close = new class_1799((class_1935)class_1802.field_8626);
                close.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText("flan.screenBack", class_124.field_1079));
                inv.updateStack(i, close);
                continue;
            }
            if (i == 3) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8782);
                stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText("flan.screenAdd", class_124.field_1077));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 4) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8793);
                stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode ? ServerScreenHelper.coloredGuiText("flan.screenTrue", new Object[0]) : ServerScreenHelper.coloredGuiText("flan.screenFalse", new Object[0]), class_124.field_1079));
                inv.updateStack(i, stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1;
            if (id >= players.size()) continue;
            class_1799 fakePlayer = new class_1799((class_1935)class_1802.field_8470);
            class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)fakePlayer, t -> t.method_10582("FlanFakePlayer", (String)players.get(id)));
            fakePlayer.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText("flan.screenFakePlayerNameUUID", players.get(id), class_124.field_1054));
            inv.updateStack(i, fakePlayer);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(class_3222 player, int index, class_1735 slot, int clickType) {
        if (index == 0) {
            player.method_7346();
            player.method_5682().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, this.claim));
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.method_7346();
            player.method_5682().execute(() -> StringResultScreenHandler.createNewStringResult((class_1657)player, s -> {
                boolean fl = player.method_5682().method_3793().method_14515(s).map(prof -> this.claim.modifyFakePlayerUUID(prof.getId(), false)).orElse(true);
                player.method_7346();
                player.method_5682().execute(() -> FakePlayerScreenHandler.open((class_1657)player, this.claim));
                if (fl) {
                    ServerScreenHelper.playSongToPlayer(player, class_3417.field_14559, 1.0f, 1.0f);
                } else {
                    player.method_7353((class_2561)ClaimUtils.translatedText("flan.playerGroupAddFail", class_124.field_1061), false);
                    ServerScreenHelper.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
                }
            }, () -> {
                player.method_7346();
                player.method_5682().execute(() -> FakePlayerScreenHandler.open((class_1657)player, this.claim));
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            class_1799 stack = new class_1799((class_1935)class_1802.field_8793);
            stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode ? ServerScreenHelper.coloredGuiText("flan.screenTrue", new Object[0]) : ServerScreenHelper.coloredGuiText("flan.screenFalse", new Object[0]), class_124.field_1079));
            slot.method_7673(stack);
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        class_1799 stack = slot.method_7677();
        if (!stack.method_7960()) {
            UUID uuid = null;
            try {
                uuid = UUID.fromString(((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10558("FlanFakePlayer"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.removeMode && uuid != null) {
                this.claim.modifyFakePlayerUUID(uuid, true);
                slot.method_7673(class_1799.field_8037);
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_14911, 1.0f, 1.0f);
            }
        }
        return false;
    }
}

